allData <- readxl::read_excel('data.xlsx', sheet = 'Запад')
DataVecOOB <- data.frame(iteration = 1:4)
Data5Predictors <- data.frame(n = 1:5)
Data4Predictors <- data.frame(n = 1:4)
Data3Predictors <- data.frame(n = 1:3)
Data2Predictors <- data.frame(n = 1:2)
library(dplyr) # ради функции filter
library(randomForest)
for(i in 1:1000) {
  newData <- allData
  vecOOB <- c()
  while (ncol(newData)-1 > 1) {
    set.seed(i)	  
    ## создаем объект случайного леса
    newData.rf <- randomForest(LnR~., data=newData, mtry=2, nodesize=1,
                               importance=TRUE, localImp=TRUE, proximity=TRUE)
    ## именуем данные по важности признаков,   
    ## type = 1 - данные по 'mean decrease in accuracy'
    imp <- importance(newData.rf, type = 1)
    ## устанавливаем критерий для фильтрации,
    ## находим 5%-квантиль, по которому будем отсекать незначимые предикторы 
    quantileProc <- quantile(imp, 0.05)
    ## представляем imp как датафрейм 
    impDataFrame <- as.data.frame(imp)
    ## добавляем в него вектор индексов 
    impDataFrame <- data.frame(MeanDecreaseAcc = impDataFrame$`%IncMSE`, 
                               index = rownames(impDataFrame))
    ## сортируем по уменьшению важности
    impDataFrame <- as.data.frame(impDataFrame[order(impDataFrame$MeanDecreaseAcc, decreasing = TRUE),])
    ## если в дата-фрейме остается 5 предикторов, запоминаем их имена
    if ((ncol(newData)-1) == 5) Predictors5 <- impDataFrame$index
    if ((ncol(newData)-1) == 4) Predictors4 <- impDataFrame$index
    if ((ncol(newData)-1) == 3) Predictors3 <- impDataFrame$index
    if ((ncol(newData)-1) == 2) Predictors2 <- impDataFrame$index
    ## фильтруем датафрейм важности по критерию quantileProc
    filterImp <- filter(impDataFrame, impDataFrame$MeanDecreaseAcc <= quantileProc)
    ## представляем filterImp как вектор 
    filterImpVector <- as.vector(filterImp$index)
    ## находим индексы совпадений
    I <-match(filterImpVector, names(newData), nomatch = 0, incomparables = NULL)  
    ## записываем значение R^2 OOB в вектор
    vecOOB <- c(vecOOB, newData.rf$rsq[newData.rf$ntree])
    ## удаляем признаки с индексом(-ами) I
    newData <- newData[ , -c(I)]
  }
  ## добавляем промежуточные результаты в датафреймы результатов 
  DataVecOOB <- cbind(DataVecOOB, vecOOB)
  Data5Predictors <- cbind(Data5Predictors, Predictors5)
  Data4Predictors <- cbind(Data4Predictors, Predictors4)
  Data3Predictors <- cbind(Data3Predictors, Predictors3)
  Data2Predictors <- cbind(Data2Predictors, Predictors2)
}
  ## удаляем инициализирующие векторы в дата-фреймах результатов
DataVecOOB <- DataVecOOB[, -1]
Data5Predictors<- Data5Predictors[, -1]
Data4Predictors<- Data4Predictors[, -1]
Data3Predictors<- Data3Predictors[, -1]
Data2Predictors<- Data2Predictors[, -1]

writexl::write_xlsx(DataVecOOB, path='OutputOOB.xlsx')
writexl::write_xlsx(Data5Predictors, path='Output5Predictors.xlsx') 
writexl::write_xlsx(Data4Predictors, path='Output4Predictors.xlsx')
writexl::write_xlsx(Data3Predictors, path='Output3Predictors.xlsx')
writexl::write_xlsx(Data2Predictors, path='Output2Predictors.xlsx')

OOBt=as.data.frame(t(DataVecOOB), row.names = FALSE)
names(OOBt)=paste0('n',5:2)
summary(OOBt)
#        n5               n4               n3               n2        
# Min.   :0.4966   Min.   :0.5130   Min.   :0.5486   Min.   :0.5905  
# 1st Qu.:0.5345   1st Qu.:0.5581   1st Qu.:0.5875   1st Qu.:0.6160  
# Median :0.5445   Median :0.5667   Median :0.5943   Median :0.6217  
# Mean   :0.5442   Mean   :0.5666   Mean   :0.5944   Mean   :0.6217  
# 3rd Qu.:0.5537   3rd Qu.:0.5755   3rd Qu.:0.6012   3rd Qu.:0.6280  
# Max.   :0.5856   Max.   :0.6099   Max.   :0.6251   Max.   :0.6486
